﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Place;
using System.ComponentModel;
using Soneta.Core;

namespace ASP {

    public partial class Zaświadczenie_O_Zarobkach_Szczegółowe : System.Web.UI.Page {

        public string Str_CultureInfo = "pl-PL";
        public string Str_Pan = "Pan:";
        public string Str_Zamieszkaly = "Zamieszkały:";
        public string Str_Pani = "Pani:";
        public string Str_Zamieszkala = "Zamieszkała:";
        public string Str_Otrzymal = "otrzymał";
        public string Str_Otrzymala = "otrzymała";
        public string Str_Zatrudniony = "zatrudniony";
        public string Str_Zatrudniona = "zatrudniona";
        public string Str_InfoEtat = "jest {0} w naszym zakładzie pracy <b>{1}</b><br>od dnia: <b>{2}</b> do dnia: {3}<br>na stanowisku: <b>{4}</b>.";
        public string Str_InfoZlec = "wykonuje pracę w naszym zakładzie na podstawie umowy zlecenia/o dzieło.";
        public string Str_ReportTitle = "<center>Zaświadczenie o zarobkach</center>|<p align=right></strong>{0}, {1}<strong></p>";

	    //W raporcie uwzględniaj następujące elementy nieopodatkowane:
	    //Pożyczki i spłaty pożyczek
	    static readonly bool pozyczkiISplaty = false;
	
	    //Zaliczki opodatkowane i ich spłaty
	    static readonly bool zaliczkiISplatyOpodatkowane = false;
	
	    //Zaliczki nieopodatkowane i ich spłaty
	    static readonly bool zaliczkiISplatyNieopodatkowane = false;
	
	    //Elementy wg nazwy
	    //Tutaj wpisujemy nazwy elementów które mają zostać uwzględnione w zesatwieniu nawet jeżeli
	    //nie spełniają innych kryteriów.
	    //Każda nazwa musi być wpisana w '"' i oddzielona ',' od następnej.
	    static readonly string[] nazwyDodatków = new string[] {};

        //A tutaj tak samo, ale elementy, które mają być zawsze pominięte    
        static readonly string[] pomińDodatki = new string[] { };
		    
	    //Dodatki nieopodatkowane
	    static readonly bool dodatkiNieopodatkowane = true;
	
	    //Potrącenie nieopodatkowane
        static readonly bool potraceniaNieopodatkowane = true;
	
	    //Uwzględniemy wszystkie elementy opodatkowane ewentualnie poza zaliczkami
	    //Oraz elementy nieopodatkowane wg podanych założeń	
	    Hashtable wyjatki = null;
	    bool Wchodzi(WypElement e) {
		    if (wyjatki==null) {
			    wyjatki = new Hashtable();
			    foreach (string nazwa in nazwyDodatków)
				    wyjatki[nazwa.ToLower()] = true;
                foreach (string nazwa in pomińDodatki)
                    wyjatki[nazwa.ToLower()] = false;
            }

            object obj = wyjatki[e.Definicja.Nazwa.ToLower()];
            if (obj != null)
                return (bool)obj;

            if (!e.Definicja.DoWyplaty)
                return false;
		
		    if (e.Definicja.Info.Opodatkowany)
			    switch (e.RodzajZrodla) {
				    case RodzajŹródłaWypłaty.Zaliczka:
				    case RodzajŹródłaWypłaty.SpłataZaliczki:
					    return zaliczkiISplatyOpodatkowane;
				    default:
					    return true;
			    }
			
		    switch (e.RodzajZrodla) {
			    case RodzajŹródłaWypłaty.Zaliczka:
			    case RodzajŹródłaWypłaty.SpłataZaliczki:
				    return zaliczkiISplatyNieopodatkowane;

			    case RodzajŹródłaWypłaty.Pożyczka:
			    case RodzajŹródłaWypłaty.PożyczkaSpłata:
				    return pozyczkiISplaty;
				
			    default:
				    return !e.Definicja.Info.Potrącenie ? dodatkiNieopodatkowane : potraceniaNieopodatkowane;
		    }		
	    }
	
	    //Wchodzi jako zasiłek rodzonny lub pielęgnacyjny?
	    bool Zasiłek(WypElement e) {
		    switch (e.Definicja.Deklaracje.PozycjaRCA) {
			    case PozycjaRCA.ZasiłekRodzinny:
			    case PozycjaRCA.DodatekRodzinny:
			    case PozycjaRCA.ZasiłekPielęgnacyjny:
			    case PozycjaRCA.DodDoZasRodzinnego:
				    return true;
		    }
		    return false;
	    }
	
        public class PrnParams: Soneta.Business.OkresContext {
    
            public PrnParams(Context context): base(context) {
                wgDatyWypłaty = true;
                YearMonth to = new YearMonth(Aktualny);
                to -= 1;
                YearMonth from = to - 2;
                base.Okres = new FromTo(from.FirstDay, to.LastDay);
            }
    
            [Browsable(false)]
		    [Caption("Aktualny")]
            public override Date Aktualny {
                get { return base.Aktualny; }
                set { base.Aktualny = value; }
            }
    
    
            [Priority(1)]
		    [Caption("Okres")]
            public override FromTo Okres {
                get { return base.Okres; }
                set {
                    if (value == FromTo.Empty)
                        value = FromTo.All;
                    base.Okres = value;
                }
            }
    
            bool wgDatyWypłaty;
            [Priority(2)]
		    [Caption("Wg Daty Wypłaty")]
            public bool WgDatyWypłaty {
                get { return wgDatyWypłaty; }
                set {
                    wgDatyWypłaty = value;
                    OnChanged(EventArgs.Empty);
                }
            }
    
            bool etat = true;
            [Priority(3)]
		    [Caption("Wypłaty Za Etat")]
            public bool WypłatyZaEtat {
                get { return etat; }
                set {
                    etat = value;
                    OnChanged(EventArgs.Empty);
                }
            }
    
            bool umowa = false;
            [Priority(4)]
		    [Caption("Umowy")]
            public bool Umowy {
                get { return umowa; }
                set {
                    umowa = value;
                    OnChanged(EventArgs.Empty);
                }
            }
    
            bool inne = false;
		    [Caption("Inne Wypłaty")]
            public bool InneWypłaty {
                get { return inne; }
                set {
                    inne = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }
    
        PrnParams pars;
        [Soneta.Business.Context(Required=true)]
        public PrnParams Params {
            get { return pars; }
            set { pars = value; }
        }
    
        Hashtable wynagrodzenia = new Hashtable();
        decimal brutto, zalPIT, netto, nieopodatkowanePlus, nieopodatkowaneMinus, eu, ef, ru, rf, cu, cf, wu, wf, z, f, k, u, p, zas;

        protected void OnContextLoad(Object sender, EventArgs args) {
            ReportHeader1.Title = String.Format(Str_ReportTitle,
                CoreModule.GetInstance(dc).Config.Firma.AdresSiedziby.Miejscowosc,
                pars.Aktualny);

            System.Globalization.CultureInfo ci = new System.Globalization.CultureInfo(Str_CultureInfo);

            Pracownik pracownik = (Pracownik)dc[typeof(Pracownik)];
            PracHistoria historia = pracownik[pars.Aktualny];

			if (historia.Plec != 0) {
				Pan.EditValue = Str_Pan;
				Otrzymał.EditValue = Str_Otrzymal;
				Zamieszkały.EditValue = Str_Zamieszkaly;
			}
			else {
				Pan.EditValue = Str_Pani;
				Otrzymał.EditValue = Str_Otrzymala;
				Zamieszkały.EditValue = Str_Zamieszkala;
			}

            sectDodatkiNetto.Visible = pozyczkiISplaty | zaliczkiISplatyNieopodatkowane | dodatkiNieopodatkowane;
            sectPotrąceniaNetto.Visible = pozyczkiISplaty | zaliczkiISplatyNieopodatkowane | potraceniaNieopodatkowane;                
                    
            Pracownik.EditValue = pracownik.ImięNazwisko;
            Adres.EditValue = historia.Adres.Linia1 + ", " + historia.Adres.Linia2;
            Pesel.EditValue = historia.PESEL;
            OkresOd.EditValue = pars.Okres.From;
            OkresDo.EditValue = pars.Okres.To;

			if (pars.WypłatyZaEtat) {
				string zatrudniony = Str_Zatrudniony;
				string zatrudniona = Str_Zatrudniona;
				string infoEtat = Str_InfoEtat;

				FromTo okres = historia.Etat.OkresZatrudnienia;
				string sto = okres.To == Date.MaxValue ? ". . . . . . . . . . . . . . ." : "<b>" + okres.To + "</b>";
				string płeć = historia.Plec != 0 ? zatrudniony : zatrudniona;
				Info.EditValue = String.Format(infoEtat, płeć, CaptionAttribute.EnumToString(historia.Etat.TypUmowy, ci).ToLower(), okres.From, sto, historia.Etat.Stanowisko);
			}
			else
				Info.EditValue = Str_InfoZlec;

            SubTable elementy;
            PlaceModule płace = PlaceModule.GetInstance(pracownik);

            foreach (Pracownik pp in pracownik.PracownicyPowiązani) {
                if (pars.WgDatyWypłaty)
                    elementy = płace.WypElementy.WgDaty[pp];
                else
                    elementy = płace.WypElementy.WgPracownik[pp];
                elementy = new SubTable(elementy, pars.Okres);

                foreach (WypElement e in elementy) {
                    if (!e.Wyplata.Zatwierdzona)
                        continue;
                    if (Zasiłek(e))
                        zas += e.Wartosc;
                    else if (Wchodzi(e)) {
                        bool ok;
                        switch (e.Wyplata.Typ) {
                            case TypWyplaty.Etat:
                                ok = pars.WypłatyZaEtat; break;
                            case TypWyplaty.Umowa:
                                ok = pars.Umowy; break;
                            default:
                                ok = pars.InneWypłaty; break;
                        }

                        if (ok) {
                            if (e.Definicja.Info.Opodatkowany) {
                                YearMonth miesiąc = new YearMonth(pars.WgDatyWypłaty ? e.Data : e.Okres.To);
                                object value = wynagrodzenia[miesiąc];
                                if (value == null)
                                    wynagrodzenia.Add(miesiąc, e.Wartosc);
                                else
                                    wynagrodzenia[miesiąc] = e.Wartosc + (decimal)value;

                                brutto += e.Wartosc;
                                netto += e.Netto;
                            }
                            else if (e.Definicja.Info.Potrącenie)
                                nieopodatkowaneMinus -= e.Netto;
                            else
                                nieopodatkowanePlus += e.Netto;
                                
                            eu += e.Podatki.Emerytalna.Prac;
                            ef += e.Podatki.Emerytalna.Firma;
                            ru += e.Podatki.Rentowa.Prac;
                            rf += e.Podatki.Rentowa.Firma;
                            cu += e.Podatki.Chorobowa.Prac;
                            cf += e.Podatki.Chorobowa.Firma;
                            wu += e.Podatki.Wypadkowa.Prac;
                            wf += e.Podatki.Wypadkowa.Firma;
                            z += e.Podatki.Zdrowotna.Prac;
							f += e.Podatki.FP.Skladka + e.Podatki.FGSP.Skladka + e.Podatki.FEP.Skladka;
                            k += e.Podatki.KosztyPIT;
                            u += e.Podatki.Ulga;
                            p += e.Podatki.ZalFIS;
                            zalPIT += e.Podatki.ZalFIS;
                        }
                    }
                }
            }

            ArrayList keys = new ArrayList(wynagrodzenia.Keys);
            keys.Sort();
            string body = "";
            decimal razem = 0;
            int miesiące = 0;
            foreach (YearMonth ym in keys) {
                decimal w = (decimal)wynagrodzenia[ym];
                if (w != 0m) {
                    body += "<TR><TD width=\"70%\"><UL><LI>" + ym + ":</LI></UL></TD><TD align=\"right\"><strong>" + w.ToString("n") + "</strong></TD></TR>";
                    razem += w;
                    miesiące++;
                }
            }

            dlBrutto.EditValue = razem;
            if (miesiące == 0)
                dlAvrBrutto.EditValue = "";
            else
                dlAvrBrutto.EditValue = Soneta.Tools.Math.RoundCy(razem / miesiące);
            Miesiące.EditValue = "<TABLE width=\"40%\" style=\"font-size: 1.8ex; font-family: Tahoma;\">" + body + "</TABLE>";
            EmerPrac.EditValue = eu;
            EmerFirma.EditValue = ef;
            RentPrac.EditValue = ru;
            RentFirma.EditValue = rf;
            ChorPrac.EditValue = cu;
            ChorFirma.EditValue = cf;
            WypadPrac.EditValue = wu;
            WypadFirma.EditValue = wf;

            EmerRazem.EditValue = eu + ef;
            RentRazem.EditValue = ru + rf;
            ChorRazem.EditValue = cu + cf;
            WypadRazem.EditValue = wu + wf;

            PracRazem.EditValue = eu + ru + cu + wu;
            FirmaRazem.EditValue = ef + rf + cf + wf;

            Razem.EditValue = eu + ru + cu + wu + ef + rf + cf + wf;

            Zdrow.EditValue = z;
            Fundusze.EditValue = f;
            Koszty.EditValue = k;
            Ulga.EditValue = u;
            ZalPIT.EditValue = zalPIT;
            BezZus.EditValue = brutto - eu - ru - cu - wu + nieopodatkowanePlus;
            Netto.EditValue = netto + nieopodatkowanePlus;

            if (sectDodatkiNetto.Visible && nieopodatkowanePlus == 0)
                sectDodatkiNetto.Visible = false;
            else
                NettoPlus.EditValue = nieopodatkowanePlus;

            if (sectPotrąceniaNetto.Visible && nieopodatkowaneMinus == 0)
                sectPotrąceniaNetto.Visible = false;
            else {
                NettoMinus.EditValue = nieopodatkowaneMinus;
                NettoPoNettoMinus.EditValue = netto + nieopodatkowanePlus - nieopodatkowaneMinus;
            }                    
                
            //System.Diagnostics.Debug.Assert(netto == brutto + nieopodatkowanePlus + nieopodatkowaneMinus - eu - ru - cu - wu - z - p);
            Zasiłki.EditValue = zas;
        }
    }
}
